%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Edge detection image segmentation algorithm
%----------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Author: Amit Narahar Pujari, Email contact: amitnpujari@gmail.com
%----------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Run time: Takes approximately 1 minute to completely execute and display the final results (depending on system configuration)
%----------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Software version: Written in MATLAB 6.5 environment
%----------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Input parameters:
% image = gray level image
% enter your choice = selection/ choice of filter, 1 = prewitt, 2 = roberts, 3 = sobel, 4 = ends program. 
%----------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Ouput parameters: 
% final segmented image(s)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

image=imread('hd03.jpg');                                     % Loads image to be clustered
image=im2double(image);                                       % Converts to double for calculations
image=rgb2gray(image);                                        % Converts RGB colour images in greyscale(for calculations)                             
choice=0;
while (choice~=4)
choice=input('1: Prewitt\n2: Roberts\n3:Sobel\n4: Exit\n Enter your choice : ');    % selection/choice of filter, to be used for segmentation of the image
switch choice
    case 1                                                                                                            %choice 1 selects 'prewitt' filter 
        PF=edge(image,'prewitt');
        figure, imshow(image),title('Original Image'),figure,imshow(PF),title('Prewitt Filter');
        
    case 2
        RF=edge(image,'roberts');
        figure, imshow(image),title('Original Image'),figure,imshow(RF),title('Roberts Filter');                      %choice 2 selects 'roberts' filter 
        
     case 3
        CF=edge(image,'sobel');                                                                  
        figure, imshow(image),title('Original Image'),figure,imshow(CF),title('Sobel Filter');                        %choice 3 selects 'sobel' filter
        
    case 4
        display('End Program');                                                                                       %choice 4 ends program
end;
end;